<main class="main-content mt-1 border-radius-lg">
    <nav class="navbar navbar-main navbar-expand-lg px-0 mx-4 shadow-none border-radius-xl" id="navbarBlur"
        navbar-scroll="true">
        <div class="container-fluid py-1 px-3">
            <div
                class="d-flex flex-column flex-lg-row justify-content-between align-items-start align-items-lg-center w-100 gap-2 gap-lg-0">
                <!-- Top Row - Breadcrumb and Mobile Menu (visible on tablet & mobile) -->
                <div class="d-flex justify-content-between w-100 d-lg-none">
                    <!-- Breadcrumb -->
                    {{-- <div>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb bg-transparent mb-0 pb-0 pt-1 px-0 me-sm-6 me-5">
                                <li class="breadcrumb-item text-md"><a class="opacity-5 text-dark"
                                        href="javascript:;">Pages</a></li>
                                <li class="breadcrumb-item text-sm text-dark active text-capitalize"
                                    aria-current="page">
                                    {{ str_replace(['-', '_', 'index', 'quotes'], [' ', ' ', '', "Order's"], Route::currentRouteName()) }}
                                </li>
                            </ol>
                            <h6 class="font-weight-bolder mb-0 text-capitalize">
                                {{ str_replace(['-', '_', 'index', 'quotes'], [' ', ' ', ' ', "Order's"], Route::currentRouteName()) }}
                            </h6>
                        </nav>
                    </div> --}}

                    <!-- Mobile Menu Button -->
                    <a href="javascript:;" class="nav-link text-body p-0" id="iconNavbarSidenav">
                        <div class="sidenav-toggler-inner">
                            <i class="sidenav-toggler-line"></i>
                            <i class="sidenav-toggler-line"></i>
                            <i class="sidenav-toggler-line"></i>
                        </div>
                    </a>
                </div>

                <!-- Left side - Breadcrumb (Desktop) -->
                {{-- <div class="d-none d-lg-block">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb bg-transparent mb-0 pb-0 pt-1 px-0 me-sm-6 me-5">
                            <li class="breadcrumb-item text-md"><a class="opacity-5 text-dark"
                                    href="javascript:;">Pages</a></li>
                            <li class="breadcrumb-item text-sm text-dark active text-capitalize" aria-current="page">
                                {{ str_replace(['-', '_', 'index'], [' '], Route::currentRouteName()) }}
                            </li>
                        </ol>
                        <h6 class="font-weight-bolder mb-0 text-capitalize">
                            {{ str_replace(['-', '_', 'index'], [' '], Route::currentRouteName()) }}
                        </h6>
                    </nav>
                </div> --}}

                <!-- Center - Contact Info (Desktop) -->
                <div class="mx-auto d-none d-md-block text-center">
                    <p class="mb-0 fw-medium">For any support with our Application, contact us at:
                        <strong>9840353040</strong>
                    </p>
                </div>

                <!-- Right side - User dropdown and buttons -->
                <div class="d-flex flex-column flex-md-row align-items-center gap-2 w-100 w-md-auto">
                    <!-- Contact Info (Mobile) -->
                    {{-- <div class="d-md-none w-100 text-center">
                        <p class="mb-0 fw-medium">Support: <strong>9840353040</strong></p>
                    </div> --}}

                    <!-- Buttons and Dropdown -->
                    <div
                        class="d-flex flex-wrap justify-content-center justify-content-md-end align-items-center gap-2 w-100">

                        <div class="flex-grow-1 flex-md-grow-0" style="min-width: 180px;">
                            <select class="form-select form-select-sm" id="switch_branch" name="switch_branch">
                                <option value="">Select Branch to Switch</option>
                                @foreach (userBranch() as $item)
                                    <option value="{{ $item->id }}" {{$item->id == session('branch_id') ? 'selected' : ''}}>
                                        {{ $item->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        @if(Auth::user()->user_flg != 'C')
                            <a class="btn bg-gradient-primary btn-sm mt-3" href="{{ route('invoice-add') }}">
                                New Invoice
                            </a>
                        @endif

                        <!-- User Dropdown -->
                        <div class="ms-md-3">
                            <ul class="navbar-nav">
                                <li class="dropdown d-flex align-items-center">
                                    <a class="nav-link dropdown-toggle text-body fw-bold px-0" href="#"
                                        id="userDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                        {{ Auth::user()->name . ' ' . Auth::user()->last_name }}
                                    </a>
                                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
                                        <li>
                                            @if (Auth::user()->user_flg == 'C')
                                                <a class="dropdown-item text-success"
                                                    href="{{route('client-edit', Auth::user()->client->id)}}">
                                                    <i class="fa-solid fa-address-card me-2"></i>View Profile
                                                </a>
                                            @endif
                                            <a class="dropdown-item text-danger" href="#" data-bs-toggle="modal"
                                                data-bs-target="#logoutModal">
                                                <i class="fa-solid fa-right-from-bracket me-2"></i>Sign Out
                                            </a>
                                        </li>
                                    </ul>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade" id="logoutModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Confirm Logout</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        Are you sure you want to logout?
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <a href="{{route('logout')}}" class="btn btn-danger">Logout</a>
                    </div>
                </div>
            </div>
        </div>
    </nav>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function () {
            $('#switch_branch').on('change', function () {
                let branchId = $(this).val();

                $.ajax({
                    url: '{{ route('switch-branch') }}',
                    type: 'POST',
                    data: {
                        branchID: branchId,
                        _token: '{{ csrf_token() }}'
                    },
                    success: function (response) {
                        location.reload();
                    },
                    error: function (xhr) {
                        console.error('Branch switch failed', xhr);
                    }
                });
            });
        });

    </script>