@extends('layouts.layoutapp')

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card me-2">
                <div class="card-header pb-0">
                    <div class="d-flex justify-content-between flex-row">
                        <div>
                            <h5 class="mb-0">Edit Order</h5>
                        </div>
                    </div>
                </div>

                <form action="{{ route('orders-update') }}" method="POST">
                    @csrf
                    <input type="hidden" name="id" value="{{ $order->id }}" />
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-3 mb-3">
                                <label for="client_id" class="form-label">
                                    Client Name:
                                </label>
                                <input name="client_id" id="client_id" class="form-control" disabled
                                    value="{{ $order->client->user->name ?? '' }}" />
                                <input type="hidden" name="client_id" value="{{ $order->client_id }}" />
                            </div>
                            <div class="col-lg-3 mb-3">
                                <label for="client_num" class="form-label">
                                    Client Number:
                                </label>
                                <div id="client_select">
                                    <select name="client_num" id="client_num_select" class="form-select" disabled>
                                        @forelse ($clients as $data)
                                            <option value="{{ $data->user->phone }}" {{ $order->client->user->phone == $data->user->phone ? 'selected' : '' }}>
                                                {{ $data->user->phone }}
                                            </option>
                                        @empty
                                            <option>No Client found</option>
                                        @endforelse
                                    </select>
                                </div>
                                @error('client_num')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-lg-3 mb-3">
                                <label for="order_id" class="form-label">
                                    Orders Id:
                                </label>
                                <input type="text" id="order_id" name="order_id" class="form-control"
                                    value="{{ $order->order_id }}" readonly required />
                            </div>
                            <div class="col-lg-3 mb-3">
                                <label for="order_date" class="form-label">
                                    Orders Date:
                                </label>
                                <input type="date" id="order_date" name="order_date" value="{{ $order->order_date }}"
                                    class="form-control" required />
                            </div>
                            <div class="col-lg-3 mb-3">
                                <label for="due_date" class="form-label">
                                    Due Date:
                                </label>
                                <input type="date" id="due_date" name="due_date" class="form-control"
                                    value="{{ $order->due_date }}" required />
                            </div>
                            <div class="col-lg-3 mb-3">
                                <label for="status" class="form-label">
                                    Status
                                </label>
                                <select name="status" id="status" class="form-select" required>
                                    <option value="3" {{ $order->status == 3 ? 'selected' : '' }}>
                                        Draft
                                    </option>
                                </select>
                            </div>
                        </div>
                        <hr />
                        <div>
                            <h5>Product Details:</h5>
                            <div class="row align-items-center">
                                <div class="col-lg-4">
                                    <button type="button" id="add-row" class="btn btn-primary">
                                        <i class="fas fa-plus"></i>
                                        Add Row
                                    </button>
                                </div>
                            </div>

                            <div class="table-responsive">
                                <table class="table-bordered table-striped table text-sm" id="products-table">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th>#</th>
                                            <th>Product</th>
                                            @if (Auth::user()->user_flg !== 'C')
                                                <th>Avl. Qty</th>
                                            @endif

                                            <th>Qty</th>
                                            <th>Unit Price</th>
                                            <th>Amount</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($order->ordersItem as $index => $item)
                                            @php
                                                $product = $products->firstWhere('id', $item->product_id);
                                                $available_qty = $product ? $product->qty : 0;
                                            @endphp

                                            <tr class="product-row">
                                                <td>{{ $index + 1 }}</td>
                                                <td>
                                                    <select name="products[{{ $index + 1 }}][id]"
                                                        class="form-select product-select" required>
                                                        <option value="">Select Product</option>
                                                        @foreach ($products as $product)
                                                            <option value="{{ $product->id }}" data-available="{{ $product->qty }}"
                                                                data-amount="{{ $item->total }}"
                                                                data-price="{{ $product->unit_price }}" {{ $item->product_id == $product->id ? 'selected' : '' }}>
                                                                {{ $product->code }}-{{ $product->branch->native_name_flag == 'A' ? ($product->native_name ?? $product->name) : $product->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    <div class="duplicate-warning-container"></div>
                                                </td>
                                                @if (Auth::user()->user_flg !== 'C')
                                                    <td>
                                                        <input type="text" class="form-control available-qty" readonly
                                                            value="{{ $available_qty }}" />
                                                    </td>
                                                @endif

                                                <td>
                                                    <input type="number" name="products[{{ $index + 1 }}][qty]"
                                                        class="form-control qty" min="1" value="{{ $item->quantity }}"
                                                        required />
                                                    <div class="invalid-feedback quantity-error" style="display: none">
                                                        Quantity exceeds available stock
                                                    </div>
                                                </td>
                                                <td>
                                                    <input type="number" name="products[{{ $index + 1 }}][unit_price]"
                                                        class="form-control unit-price" min="0" step="0.01"
                                                        value="{{ $item->price }}" required readonly />
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control amount" readonly
                                                        value="{{ $item->total }}" />
                                                </td>
                                                <td class="text-center align-middle">

                                                    <a href="javascript:void(0);" class="text-danger fs-5 remove-row"
                                                        title="Remove Row">
                                                        <i class="fas fa-trash"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="row d-flex justify-content-between">
                            <div class="col-lg-7 mb-3">
                                <div class="card shadow-lg">
                                    <div class="d-flex justify-content-between px-3 pt-3 pb-0">
                                        <h5 class="px-3 pt-3 pb-0">Address</h5>
                                        <div>
                                            <button type="button" class="btn btn-primary mb-3" data-bs-toggle="modal"
                                                data-bs-target="#addAddressModal">
                                                Add New Address
                                            </button>
                                            {{-- <a href="javascript:void(0)"
                                                class="btn btn-secondary remove-address">Remove Address</a> --}}
                                        </div>

                                    </div>
                                    <div class="card-body address-body px-3 pb-2 pt-2"></div>
                                </div>
                            </div>
                            <div class="col-lg-5 mb-3">
                                <div class="card shadow-lg">
                                    <div class="card-body">
                                        <div class="d-flex justify-content-between pl-5">
                                            <span>Sub Total:</span>
                                            <span id="sub-total">{{ $order->sub_total }} ₹</span>
                                        </div>
                                        <div class="d-flex justify-content-between pl-5">
                                            <span>Discount:</span>
                                            <span id="discount-amt">{{ $order->discount_amount }} ₹</span>
                                        </div>
                                        <div class="d-flex justify-content-between pl-5">
                                            <span>Total:</span>
                                            <span id="total-amt">{{ $order->total_amount }} ₹</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <input type="hidden" id="hidden-sub-total" name="sub_total" value="{{ $order->sub_total }}" />
                        <input type="hidden" id="hidden-discount-amt" name="discount_amount"
                            value="{{ $order->discount_amount }}" />
                        <input type="hidden" id="hidden-total-amt" name="total_amount" value="{{ $order->total_amount }}" />
                        <input type="hidden" id="hidden-total-amt" name="type" value="{{ $type }}" />

                        <div class="modal-footer mt-4">
                            <button type="submit" id="submit" class="btn btn-primary">
                                Update
                            </button>
                            <a href="{{ route('orders-index') }}" class="btn btn-secondary">
                                Cancel
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade" id="addAddressModal" tabindex="-1" aria-labelledby="addAddressModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form id="addAddressForm">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="addAddressModalLabel">
                            Add New Address
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="new_address" class="form-label">
                                Address
                            </label>
                            <textarea class="form-control" id="new_address" name="address" rows="3" required></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            Cancel
                        </button>
                        <button type="button" class="btn btn-primary save-address">
                            Save Address
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        const isAvl = @json($branch->avl_qty_flag);
        $(document).ready(function () {

            let rowCount = {{ count($order->ordersItem) }};
            let hasQuantityError = false;
            const isClientUser = {{ Auth::user()->user_flg === 'C' ? 'true' : 'false' }};
            fetchClientAddress($('#client_num_select').val());

            if ($('#notes-terms').is(':visible')) {
                $('#toggle-notes').html('<i class="fas fa-minus"></i> Remove Note & Term');
            }

            // Add row button
            $('#add-row').click(function () {
                rowCount++;
                const row = `
                                                                <tr class="product-row">
                                                                   <td>${rowCount}</td>
                                                                    <td>
                                                                        <select name="products[${rowCount}][id]" class="form-select product-select" required>
                                                                            <option value="">Select Product</option>
                                                                            @foreach ($products as $product)
                                                                                <option value="{{ $product->id }}" 
                                                                                        data-available="{{ $product->qty }}" 
                                                                                        data-amount=0 
                                                                                        data-price="{{ $product->unit_price }}">
                                                                                    {{ $product->code }}-{{ $product->branch->native_name_flag == 'A' ? ($product->native_name ?? $product->name) : $product->name }}
                                                                                </option>
                                                                            @endforeach
                                                                        </select>
                                                                         <div class="duplicate-warning-container"></div>
                                                                    </td>
                                                                    ${!isClientUser ? `<td>
                                                                                    <input type="text" class="form-control available-qty" readonly>
                                                                                </td>` : ''}
                                                                    <td>
                                                                        <input type="number" name="products[${rowCount}][qty]" 
                                                                               class="form-control qty" step="1" min="1" required>
                                                                        ${!isClientUser ? `<div class="invalid-feedback quantity-error" style="display: none;">
                                                                                        Quantity exceeds available stock
                                                                                    </div>` : ''}
                                                                    </td>
                                                                    <td>
                                                                        <input type="number" name="products[${rowCount}][unit_price]" 
                                                                               class="form-control unit-price" min="0" step="0.01" required readonly>
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" class="form-control amount" readonly>
                                                                    </td>
                                                                    <td class="text-center align-middle">

                                      <a href="javascript:void(0);"
                                                                            class="text-danger fs-5 remove-row" title="Remove Row">
                                                                            <i class="fas fa-trash"></i>
                                                                        </a>
                                    </td>
                                                                </tr>
                                                            `;
                $('#products-table tbody').append(row);
                $('#products-table tbody tr:last .product-select').select2({
                    placeholder: "Select Product",
                    width: '100%'
                });
            });
            $('.product-select').select2({
                placeholder: "Select Product",
                width: '100%'
            });

            // Remove row
            $(document).on('click', '.remove-row', function () {
                $(this).closest('tr').remove();
                calculateTotals();
                renumberRows();
            });

            // Product select change
            // function handleProductSelection(selectElement) {
            //     const selectedOption = $(selectElement).find('option:selected');
            //     const row = $(selectElement).closest('tr');

            //     const price = selectedOption.data('price');
            //     const originalAvailableQty = selectedOption.data('available') || 0;

            //     let qtyInput = row.find('.qty');

            //     let qty = parseFloat(qtyInput.val()) || 0;

            //     const errorDiv = row.find('.quantity-error');

            //     if (!isClientUser) {
            //         if (isAvl != 'A') {
            //             if (qty > originalAvailableQty) {
            //                 qty = originalAvailableQty;
            //                 errorDiv.show().text('Quantity limit exceeded.');
            //                 qtyInput.addClass('is-invalid');
            //             } else {
            //                 errorDiv.hide();
            //                 qtyInput.removeClass('is-invalid');
            //             }
            //         }

            //         // const remainingQty = Math.max(originalAvailableQty - qty, 0);
            //         row.find('.available-qty').val(originalAvailableQty);
            //     }

            //     row.find('.unit-price').val(price);

            //     calculateRowAmount(row);
            //     calculateTotals();
            // }
            function handleProductSelection(selectElement) {
                const selectedOption = $(selectElement).find('option:selected');
                const row = $(selectElement).closest('tr');
                const price = selectedOption.data('price');
                const originalAvailableQty = selectedOption.data('available') || 0;
                const productId = $(selectElement).val();

                let qtyInput = row.find('.qty');
                let qty = parseFloat(qtyInput.val()) || 0;
                const errorDiv = row.find('.quantity-error');

                $('.duplicate-warning').remove();
                $('.duplicate-row').removeClass('duplicate-row');

                if (!isClientUser && isAvl != 'A') {
                    if (qty > originalAvailableQty) {
                        qty = originalAvailableQty;
                        errorDiv.show().text('Quantity limit exceeded.');
                        qtyInput.addClass('is-invalid');
                    } else {
                        errorDiv.hide();
                        qtyInput.removeClass('is-invalid');
                    }
                }

                row.find('.available-qty').val(originalAvailableQty);
                row.find('.unit-price').val(price);

                if (productId) {
                    let duplicateFound = false;

                    $('.product-select').each(function () {
                        if ($(this).val() === productId && $(this).closest('tr')[0] !== row[0]) {
                            duplicateFound = true;
                            row.addClass('duplicate-row');
                            $(this).closest('tr').addClass('duplicate-row');

                            const warningHTML = `
                                <div class="duplicate-warning text-danger small mt-1">
                                    <i class="fas fa-exclamation-triangle"></i> Duplicate product selected
                                </div>
                            `;

                            row.find('td:eq(1)').append(warningHTML);
                            $(this).closest('tr').find('td:eq(1)').append(warningHTML);
                        }
                    });

                    $('#add-row, #submit').prop('disabled', duplicateFound);
                }

                calculateRowAmount(row);
                calculateTotals();
            }


            $(document).on('change', '.product-select', function () {
                const row = $(this).closest('tr');
                row.find('.qty').val(1);
                handleProductSelection(this);
            });
            $(document).ready(function () {
                $('.product-select').each(function () {
                    if ($(this).val()) {
                        handleProductSelection(this);
                    }
                });
            });

            // Quantity or unit price change
            $(document).on('change', '.qty, .unit-price', function () {
                const row = $(this).closest('tr');
                calculateRowAmount(row);
                calculateTotals();
            });
            $(document).on('focus', '.qty', function () {
                $(this).data('prev', parseFloat($(this).val()) || 0);
            });

            $(document).on('input', '.qty', function () {
                if (isClientUser) {
                    const row = $(this).closest('.product-row');
                    calculateRowAmount(row);
                    calculateTotals();
                    return;
                }

                const input = $(this);
                const row = input.closest('.product-row');
                const errorDiv = row.find('.quantity-error');

                const newQty = parseFloat(input.val()) || 0;
                const availableQty = parseFloat(row.find('.available-qty').val()) || 0;
                if (isAvl != 'A') {
                    if (newQty > availableQty) {
                        errorDiv.show();
                        input.addClass('is-invalid');
                        return;
                    }
                }

                errorDiv.hide();
                input.removeClass('is-invalid');

                input.data('prev', newQty);

                calculateRowAmount(row);
                calculateTotals();
            });


            $(document).ready(function () {
                $('.qty').each(function () {
                    $(this).data('prev', parseFloat($(this).val()) || 0);
                });
            });

            $('.product-row').each(function () {
                const row = $(this);
                const amount = parseFloat(row.find('.amount').val()) || 0;
                const name = row.find('.product-select').attr('name').replace('[id]', '[amount]');

                if (row.find('input[name^="products"][name$="[amount]"]').length === 0) {
                    row.append($('<input>').attr({
                        type: 'hidden',
                        name: name,
                        value: amount.toFixed(2)
                    }));
                }
            });

            // Discount type or amount change
            $('#discount').prop('disabled', $('#discount_type').val() === '');
            $(document).on('change', '#discount_type', function () {
                const discountType = $(this).val();
                if (discountType) {
                    $('#discount').prop('disabled', false);
                } else {
                    $('#discount').prop('disabled', true).val('');
                }
                calculateTotals();
            });

            $(document).on('input', '#discount', function () {
                calculateTotals();
            });

            // Calculate row amount
            function calculateRowAmount(row) {

                const qty = parseFloat(row.find('.qty').val()) || 0;
                const unitPrice = parseFloat(row.find('.unit-price').val()) || 0;

                const amount = qty * unitPrice;

                row.find('.amount').val(amount.toFixed(2));

                let amountInput = row.find('input[name^="products"][name$="[amount]"]');
                if (amountInput.length === 0) {
                    const name = row.find('.product-select').attr('name').replace('[id]', '[amount]');
                    amountInput = $('<input>').attr({
                        type: 'hidden',
                        name: name,
                        value: amount.toFixed(2)
                    });
                    row.append(amountInput);
                } else {
                    amountInput.val(amount.toFixed(2));
                }
            }

            // Calculate totals
            function calculateTotals() {
                let subTotal = 0;

                $('.product-row').each(function () {
                    const amount = parseFloat($(this).find('.amount').val()) || 0;
                    if (!isNaN(amount)) {
                        subTotal += amount;
                    }
                });

                const discountType = $('#discount_type').val();
                const discount = parseFloat($('#discount').val()) || 0;
                let discountAmount = 0;

                if (discountType == 2) {
                    if (discount >= 0 && discount <= 100) {
                        discountAmount = (subTotal * discount) / 100;
                    } else {
                        $('#discount').val('');
                        discountAmount = 0;
                    }
                } else if (discountType == 1) {
                    discountAmount = Math.min(discount, subTotal);
                }

                const total = Math.max(0, subTotal - discountAmount);

                // Update totals in the UI
                $('#sub-total').text(subTotal.toFixed(2) + ' ₹');
                $('#discount-amt').text(discountAmount.toFixed(2) + ' ₹');
                $('#total-amt').text(total.toFixed(2) + ' ₹');

                // Update hidden inputs
                $('#hidden-sub-total').val(subTotal.toFixed(2));
                $('#hidden-discount-amt').val(discountAmount.toFixed(2));
                $('#hidden-total-amt').val(total.toFixed(2));
            }

            // Renumber rows
            function renumberRows() {
                let count = 1;
                $('.product-row').each(function () {
                    $(this).find('td:first').text(count);
                    count++;
                });
            }

            // Form submission handler
            $('form').on('submit', function (e) {
                if (!isClientUser) {
                    let hasError = false;

                    $('.product-row').each(function () {
                        const row = $(this);
                        const qty = parseFloat(row.find('.qty').val()) || 0;
                        const available = parseFloat(row.find('.available-qty').val()) || 0;
                        const errorDiv = row.find('.quantity-error');
                        if (isAvl != 'A') {
                            if (qty > available) {
                                row.find('.qty').addClass('is-invalid');
                                errorDiv.show().text('Quantity exceeds available stock.');
                                hasError = true;
                            } else {
                                row.find('.qty').removeClass('is-invalid');
                                errorDiv.hide();
                            }
                        }
                    });

                    if (hasError) {
                        e.preventDefault();
                        alert(
                            'Please correct the quantities that exceed available stock before submitting.');
                        return false;
                    }
                }

                return true;
            });

            function fetchClientAddress(clientId) {
                if (!clientId) return;

                $.ajax({
                    url: `/get-client-address/${clientId}`,
                    type: 'GET',
                    success: function (data) {
                        let addressHtml = '';

                        if (data.address.length > 0) {
                            data.address.forEach(function (address, index) {
                                const isChecked = address.oprtnl_flag === 'A' ? 'checked' : '';
                                const displayAddress = address.address ?? 'No Address Provided';

                                addressHtml += `
                                                                <div class="mb-3 position-relative">
                                                                    <label class="card p-3 position-relative shadow-sm address-card" style="cursor: pointer; width: 100%;">
                                                                        <span class="position-absolute top-50 end-0 translate-middle-y me-3 fa-lg text-danger remove-address-icon"
                                                                            style="z-index: 2; cursor: pointer;"
                                                                            data-address-id="${address.id}"
                                                                            data-client-id="${address.client_id}">
                                                                            <i class="fas fa-trash"></i>
                                                                        </span>
                                                                         <input type="radio" name="selected_address" class="position-absolute top-50 start-0 translate-middle-y ms-3" 
                                                                              id="address_${index}" value="${address.id}" data-client-id="${address.client_id}" ${isChecked}>

                                                                        <div class="card-body p-0 px-3">
                                                                            <p class="mb-0 text-dark">${displayAddress}</p>
                                                                        </div>
                                                                    </label>
                                                                </div>
                                                            `;

                            });
                        } else {
                            addressHtml = '<p class="text-muted">No addresses found for this client.</p>';
                        }

                        $('.address-body').html(addressHtml);
                    },
                    error: function (xhr) {
                        console.error(xhr);
                        $('.address-body').html('<p class="text-danger">Failed to load addresses.</p>');
                    },
                });
            }

            $('#addAddressForm').on('click', '.save-address', function (e) {
                e.preventDefault();

                const clientId = $('#client_num_select').val();
                const address = $('#new_address').val();

                $.ajax({
                    url: '/store-client-address',
                    type: 'POST',
                    data: {
                        client_id: clientId,
                        address: address,
                        _token: '{{ csrf_token() }}',
                    },
                    success: function (response) {
                        $('#addAddressModal').modal('hide');
                        $('#new_address').val('');
                        fetchClientAddress(clientId);
                    },
                    error: function (xhr) {
                        console.error(xhr);
                    }
                });
            });
            $(document).on('click', '.remove-address-icon', function () {
                const addressID = $(this).data('address-id');
                const clientID = $(this).data('client-id');

                Swal.fire({
                    title: "Are you sure?",
                    text: "You won't be able to revert this!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#f53939",
                    cancelButtonColor: "#8392AB",
                    confirmButtonText: "Yes, delete it!"
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: '{{ url("remove-client-address") }}',
                            type: 'GET',
                            data: { addressID: addressID, clientID: clientID },
                            success: function () {
                                fetchClientAddress(clientID);
                            },
                            error: function () {
                                Swal.fire('Error!', 'Something went wrong.', 'error');
                            }
                        });
                    }
                });
            });

            calculateTotals();
        });
    </script>
@endpush