<!-- Add Product Modal -->
<div class="modal fade" id="addProductModal" tabindex="-1" aria-labelledby="addProductModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <form id="addProductForm">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="addProductModalLabel">Add New Product</h5>
                    <button type="button" class="btn-close text-dark" data-bs-dismiss="modal"
                        aria-label="Close">X</button>
                </div>

                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-3">
                            <label class="form-label mb-0">Category</label>
                            <select class="form-select form-select-sm" name="product[0][category_id]" required>
                                <option value="">Select Category</option>
                                @foreach($category as $cat)
                                    <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                                @endforeach
                            </select>
                            <small class="text-danger error-message" id="error-category_id"></small>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label mb-0">Product Name</label>
                            <input type="text" class="form-control form-control-sm" name="product[0][name]"
                                placeholder="Product Name" required>
                            <small class="text-danger error-message" id="error-name"></small>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label mb-0">Native Name</label>
                            <input type="text" class="form-control form-control-sm" name="product[0][native_name]"
                                placeholder="Native Name">
                            <small class="text-danger error-message" id="error-native_name"></small>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label mb-0">Product Code</label>
                            <input type="text" class="form-control form-control-sm" name="product[0][productCode]"
                                placeholder="Code" required>
                            <small class="text-danger error-message" id="error-product_code"></small>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label mb-0">Buying Price</label>
                            <input type="number" step="0.01" class="form-control form-control-sm"
                                name="product[0][margin_price]" placeholder="Buying Price" required>
                            <small class="text-danger error-message" id="error-buying_price"></small>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label mb-0">Selling Price</label>
                            <input type="number" step="0.01" class="form-control form-control-sm"
                                name="product[0][unit_price]" placeholder="Selling Price" required>
                            <small class="text-danger error-message" id="error-selling_price"></small>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label mb-0">HSN Code</label>
                            <input type="text" class="form-control form-control-sm" name="product[0][hsnCode]"
                                placeholder="HSN Code">
                            <small class="text-danger error-message" id="error-hsn_code"></small>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label mb-0">Product Type</label>
                            <select class="form-select form-select-sm" name="product[0][product_type]" required>
                                <option value="">Select Type</option>
                                @foreach($product_type as $type)
                                    <option value="{{ $type->id }}" {{ $type->name == 'Ready Product' ? 'selected' : '' }}>
                                        {{ $type->name }}
                                    </option>
                                @endforeach
                            </select>
                            <small class="text-danger error-message" id="error-product_type"></small>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label mb-0">Image</label>
                            <input type="file" class="form-control form-control-sm product_image" name="product[0]['product_image']" accept="image/*">
                            <small class="text-danger error-message" id="error-product_image"></small>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label mb-0">Description</label>
                            <input type="text" class="form-control form-control-sm" name="product[0][description]"
                                placeholder="Description">
                            <small class="text-danger error-message" id="error-description"></small>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary btn-sm">Save Product</button>
                </div>
            </form>
        </div>
    </div>
</div>
@push('scripts')
    <script>
        $(document).ready(function () {
            let addProductModal;

            $('.addProduct').on('click', function () {
                var myModal = new bootstrap.Modal(document.getElementById('addProductModal'), {
                    backdrop: 'static'
                });
                myModal.show();
            });

            $('#addProductForm').on('submit', function (e) {
                e.preventDefault();

                const form = $(this);
                const formData = form.serialize();

                $('.error-message').text('');
                form.find('.is-invalid').removeClass('is-invalid');

                $.ajax({
                    url: "{{ route('product-store') }}",
                    method: "POST",
                    data: formData,
                    success: function (res) {
                        if (res.status === 'success') {
                            var myModal = new bootstrap.Modal(document.getElementById('addProductModal'));
                            myModal.hide();
                            form[0].reset();

                            Swal.fire({
                                title: 'Success!',
                                text: res.message,
                                icon: 'success',
                                confirmButtonText: 'OK'
                            });

                            refreshProductDropdowns();
                        }
                    },
                    error: function (xhr) {
                        if (xhr.status === 422) {
                            const errors = xhr.responseJSON.errors;

                            Object.entries(errors).forEach(([field, messages]) => {
                                $(`[name="${field}"]`).addClass('is-invalid');
                                $(`#error-${field}`).text(messages[0]);
                            });

                            const msgArr = Object.values(errors.form || {});
                            Swal.fire({
                                title: 'Validation Error!',
                                text: msgArr.join(', '),
                                icon: 'error',
                                confirmButtonText: 'OK'
                            });
                        }
                        else {
                            // Unexpected error
                            Swal.fire({
                                title: 'Error!',
                                text: 'An unexpected error occurred.',
                                icon: 'error',
                                confirmButtonText: 'OK'
                            });
                        }
                    }
                });

            });
        });

    </script>
@endpush